<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MouvementEffectif extends Model 
{

    protected $table = 'mouvements_effectifs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'slug', 'id_utilisateur', 'id_vague', 'id_typeCaisse', 'effectif', 'prix', 'motif', 'commentaire', 'type', 'statut');
    protected $visible = array('date', 'slug', 'id_utilisateur', 'id_vague', 'id_typeCaisse', 'effectif', 'prix', 'motif', 'commentaire', 'type', 'statut');

    public function utilisateur()
    {
        return $this->belongsTo('App\Models\Utilisateur', 'id_utilisateur');
    }

    public function vague()
    {
        return $this->belongsTo('App\Models\Vague', 'id_vague');
    }

    public function typeCaisse()
    {
        return $this->belongsTo('App\Models\TypeCaisse', 'id_typeCaisse');
    }

}